//
//   dcldemo.dcl
//
//   Written by Phillip Norman
//
//   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED
//   WARRANTY.  ALL IMPLIED WARRANTIES OF FITNESS FOR ANY PARTICULAR
//   PURPOSE AND OF MERCHANTABILITY ARE HEREBY DISCLAIMED.
//
//   October 2005
//
////////////////
DCLDEMO : dialog {label="DCL - LISP Dialog Demo";
  : column {
    dmo_maindcl;
  }
}

DCLDEMO_CODE : dialog {label="DCL - LISP Dialog Demo";
  : column {
    dmo_maindcl;
    dmo_code_row;
  }
}

dmo_maindcl
    : row {
      : boxed_column {label="Description:";
        : list_box {key="ppn_complist"; width=20; height=25;}
      }
      : column {
        : boxed_row {label="Component Type:";
          : radio_column {
            : radio_button {label="W Flange - ID 1"; key="ppn_wf";}
            : radio_button {label="Std. Channels - ID 3"; key="ppn_ch";}
            : radio_button {label="Angles - ID 5"; key="ppn_ea";}
            : radio_button {label="Rect. HSS - ID 7"; key="ppn_rhs";}
          }
          : radio_column {
            : radio_button {label="Welded W Flange - ID 2"; key="ppn_wwf";}
            : radio_button {label="Misc. Channels - ID 4"; key="ppn_mch";}
            : radio_button {label="Std. Beams - ID 6"; key="ppn_sb";}
            : radio_button {label="Circ. HSS - ID 8"; key="ppn_chs";}
          }
        }
        : boxed_row {label="Insertion Point:";
          : text_part {label="  X,Y,Z:"; fixed_width=true;}
          : text_part {key="ppn_insp"; width=20;}
          : button {label = "Pick Point <"; key="ppn_graphscr"; width=10; fixed_width=true;}
        }
        : boxed_column {label="Options:";
          : row {
            : popup_list {label="View:"; key="ppn_view"; edit_width=14; fixed_width=true;
                          list="Section (0)\nPlan (1)\nElevation (2)";}
            : edit_box {label="Rotation Angle"; key="ppn_rotang"; edit_width=5; fixed_width=true;}
          }
          spacer_1;
          : row {
            : column {
              : toggle {label="Hide web/flange."; key="ppn_hide";}
              : toggle {label="Hatch section."; key="ppn_hatch";}
            }
            : column {
              : toggle {label="Draw 1st end."; key="ppn_1stend";}
              : toggle {label="Draw 2nd end."; key="ppn_2ndend";}
            }
          }
        }
        dmo_about_ok_cancel_code;
      }
    }

dmo_about_ok_cancel_code
  : column {children_alignment=centered;
    ok_cancel;
    : row {fixed_width=true;
      : button {label="About"; key="ppn_about"; fixed_width=true;}
      : spacer {width=1.5;}
      : button {label="Center DCL"; key="ppn_repos"; fixed_width=true;}
      : spacer {width=1.5;}
      : toggle {key="ppn_code"; label="Show Code"; fixed_width=true;}
    }
  }  

dmo_code_row
  : row {label="Code:";
    : list_box  {key="ppn_codetxt"; tabs="5 40";}
  }

// modified from original By Gary Fowler
//
//   Original widgets by Gary Fowler
dmo_copyright_exit 
  :row {       
    : image_button {key="set-copyright"; width=90; height=0.875; is_cancel=true; color=132;}
  } 

DMO_ABOUT: dialog {key="set-title"; width=93.3; height=34.875; initial_focus="set-copyright";
  :boxed_column {label="DCL Demo Variable Info";
    : text_part {value="  Global Variable                Value                                                  Local Variable        Current Value";}
    : list_box {key="dmoinfo"; multiple_select=false; tabs="20 50 65";}
  }
  :boxed_row {children_fixed_width=true; children_fixed_height=true;
    : spacer {width=0.125;}
    : column {
      : boxed_row {
        : spacer {width=2.125;}
        : column {
          : boxed_column {width=70;
            : text {key="hello1"; alignment=centered; fixed_width_font=true;}
            : text {key="hello2"; alignment=centered;}
            : text {key="hello3"; alignment=centered;}
            : text {key="hello4"; alignment=centered;}
            : text {key="hello5"; alignment=centered;}
            : text {key="hello6"; alignment=centered;}             
            : spacer {}        
          } 
          : spacer {height=0.875;}   
        }  
        : spacer {width=1;}
        : spacer {height=0.25;}
      }       
      : spacer {width=1;}    
      : spacer {height=0.25;}
    }    
    : spacer {width=1;}    
  }  
  : spacer {height=0.2;}
  dmo_copyright_exit;
}
